# Generated by default/object.tt
package Paws::LocationService::SearchPlaceIndexForPositionSummary;
  use Moose;
  has DataSource => (is => 'ro', isa => 'Str', required => 1);
  has MaxResults => (is => 'ro', isa => 'Int');
  has Position => (is => 'ro', isa => 'ArrayRef[Num]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LocationService::SearchPlaceIndexForPositionSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LocationService::SearchPlaceIndexForPositionSummary object:

  $service_obj->Method(Att1 => { DataSource => $value, ..., Position => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LocationService::SearchPlaceIndexForPositionSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->DataSource

=head1 DESCRIPTION

A summary of the reverse geocoding request sent using
C<SearchPlaceIndexForPosition>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DataSource => Str

The data provider of geospatial data. Indicates one of the available
providers:

=over

=item *

Esri

=item *

HERE

=back

For additional details on data providers, see the Amazon Location
Service data providers page
(https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).


=head2 MaxResults => Int

An optional parameter. The maximum number of results returned per
request.

Default value: C<50>


=head2 B<REQUIRED> Position => ArrayRef[Num]

The position given in the reverse geocoding request.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LocationService>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

