/*
 * Decompiled with CFR 0.152.
 */
package com.vizdom.dbd.jdbc;

import com.vizdom.dbd.jdbc.BerDbdModule;
import com.vizdom.dbd.jdbc.Connection;
import com.vizdom.dbd.jdbc.FatalException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Server
implements Runnable {
    private static final Logger gLog = LogManager.getLogger(Server.class);
    private ServerSocket mSocket;
    private java.sql.Connection mConn;

    public static void main(String[] args) {
        int portnum;
        if (args.length > 0) {
            System.err.println("DBD::JDBC server 0.72");
            System.err.println("Required system properties:");
            System.err.println("  -Djdbc.drivers=[driverlist]");
            System.err.println("  -Ddbd.port=[portnum]");
            return;
        }
        try {
            String port = System.getProperty("dbd.port");
            if (port == null) {
                throw new FatalException("Property dbd.port was not specified.");
            }
            portnum = Integer.parseInt(port);
        }
        catch (NumberFormatException nf) {
            throw new FatalException("Property dbd.port is not an integer.");
        }
        catch (SecurityException se) {
            throw new FatalException("Unable to access property dbd.port.");
        }
        CloseableThreadContext.Instance ctc = CloseableThreadContext.push((String)"Server");
        try {
            try {
                BerDbdModule.gBerModule.setCharacterEncoding("ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new FatalException("ASCII character encoding is not supported");
            }
            ServerSocket ss = null;
            try {
                try {
                    ss = new ServerSocket(portnum);
                    gLog.info("[Server] accepting connections");
                    while (true) {
                        try {
                            while (true) {
                                Server.gCreateThread(ss.accept());
                            }
                        }
                        catch (Exception e) {
                            gLog.warn("[Server] " + e.toString());
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioError) {
                    throw new FatalException(ioError.toString());
                }
            }
            catch (Throwable throwable) {
                try {
                    if (ss != null) {
                        ss.close();
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            if (ctc != null) {
                try {
                    ctc.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
            }
            throw throwable;
        }
    }

    private static void gCreateThread(Socket socket) throws Exception {
        gLog.info("[Server] received a connection from " + socket.getInetAddress());
        Thread t = new Thread(new Connection(socket, (BerDbdModule)BerDbdModule.gBerModule.clone()));
        if (t == null) {
            throw new Exception("Failed to create client thread.");
        }
        t.start();
        t = null;
    }

    public Server(java.sql.Connection aConnection) throws IOException {
        this(aConnection, 0);
    }

    public Server(java.sql.Connection aConnection, int aPortNumber) throws IOException {
        this.mConn = aConnection;
        this.mSocket = new ServerSocket(aPortNumber);
    }

    public int getPort() {
        return this.mSocket.getLocalPort();
    }

    @Override
    public void run() {
        try {
            BerDbdModule.gBerModule.setCharacterEncoding("ASCII");
            Connection dbiConn = new Connection(this.mSocket.accept(), (BerDbdModule)BerDbdModule.gBerModule.clone(), this.mConn);
            dbiConn.run();
            dbiConn = null;
            this.mConn = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

