######## GeoData for Geo::Location::TimeZone - Check main library for copyright.
######## Roughly GMT 4
package Geo::Location::TimeZone::D;
use Class::Singleton;
use Geo::Location::TimeZone;
@ISA = qw(Class::Singleton Geo::Location::TimeZone);
# Coordinates are X,Y, NOT lat,lon
# Output of partial data at 1172109537
my $data = {
	# Longitude 52.5 to 67.5
	"4" => {
		# Grid 4:-6 ; 2 records
		"-6" => {
			"def_z" => "Antartica/South_Pole",
			"346" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,2",
				"p" => [[55.8617324829102,-82.5],[52.5212826667773,-82.5],[52.5213241577148,-88.9741668701172],[52.5213317871094,-90],[52.5,-90],[52.5,-82.5],[52.5,-82.5],[55.8617324829102,-82.5],],
			},
		},
		# Grid 4:-5 ; 2 records
		"-5" => {
			"def_z" => "Antartica/Mawson",
			"347" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,2",
				"p" => [[52.5211853102317,-67.5],[52.5212440490723,-76.4741668701172],[52.5212826667773,-82.5],[52.5,-82.5],[52.5,-67.5],[52.5206718444824,-67.5],[52.5211853102317,-67.5],],
			},
		},
		# Grid 4:-4 ; 1 records
		"-4" => {
			"348" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,2",
				"p" => [[52.5213317871094,-67.5],[52.5,-67.5],[52.5,-52.5],[52.5210871303537,-52.5],[52.5211853102317,-67.5],[52.5213317871094,-67.5],],
			},
		},
		# Grid 4:-3 ; 1 records
		"-3" => {
			"349" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,2",
				"p" => [[52.5213317871094,-52.5],[52.5,-52.5],[52.5,-37.5],[52.520988638253,-37.5],[52.5209999084473,-39.1741676330566],[52.5210871303537,-52.5],[52.5213317871094,-52.5],],
			},
		},
		# Grid 4:-2 ; 1 records
		"-2" => {
			"350" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,2",
				"p" => [[55.8617324829102,-22.5],[52.5208876609611,-22.5],[52.520988638253,-37.5],[52.5,-37.5],[52.5,-22.5],[52.5,-22.5],[55.8617324829102,-22.5],],
			},
		},
		# Grid 4:-1 ; 1 records
		"-1" => {
			"351" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,2",
				"p" => [[52.5,-10.4781742095947],[52.5,-7.5],[52.5207898961638,-7.5],[52.5208854675293,-22.1741695404053],[52.5208876609611,-22.5],[52.5,-22.5],[52.5,-10.4781742095947],],
			},
		},
		# Grid 4:0 ; 1 records
		"0" => {
			"352" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,2",
				"p" => [[52.5,7.5],[52.5206922026978,7.5],[52.5207898961638,-7.5],[52.5,-7.5],[52.5,-1.3858335018158],[52.5,7.5],],
			},
		},
		# Grid 4:1 ; 1 records
		"1" => {
			"353" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,2",
				"p" => [[52.5,22.5],[55.332390083708,22.5],[55.6661071777344,21.9997215270996],[55,20],[52.5,19.1663170687678],[52.5,17.9412312213727],[53.1144409179688,16.6427783966064],[52.9438858032227,16.6080551147461],[52.5213279724121,16.4376411437988],[52.5213279724121,13.6126585006714],[55.8617324829102,13.6126585006714],[55.8617324829102,10.628565788269],[52.5206718444824,10.6258306503296],[52.5206922026978,7.5],[52.5,7.5],[52.5,8.36494636535645],[52.5,22.5],],
			},
		},
		# Grid 4:2 ; 6 records
		"2" => {
			"def_z" => "Asia/Tehran",
			"354" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,2",
				"p" => [[52.5,30.325740814209],[52.5,27.4922840774247],[52.5213279724121,27.4864673614502],[52.5213279724121,24.1205368041992],[52.5,24.1070107381133],[52.5,23.0370318589848],[52.5833282470703,22.9388904571533],[55.141658782959,22.6333293914795],[55.1991653442383,22.6997184753418],[55.332390083708,22.5],[52.5,22.5],[52.5,32.4919357299805],[52.5,30.325740814209],],
			},
			"524" => {
				"z1" => "55.28,25.2522222,Asia/Dubai",
				"z0" => "58.5933333,23.6133333,Asia/Muscat",
				"c" => "ESRI",
				"s" => "35,5",
				"p" => [[52.5206718444824,22.5],[55.332390083708,22.5],[55.1991653442383,22.6997184753418],[55.141658782959,22.6333293914795],[52.5833282470703,22.9388904571533],[52.5,23.0370318589848],[52.5,24.1070107381133],[52.5213279724121,24.1205368041992],[52.5213279724121,27.4864673614502],[52.5654487609863,27.3583583831787],[53.1448402404785,26.8033103942871],[54.4740333557129,26.2628707885742],[54.488639831543,25.8831024169922],[54.5568046569824,25.8684940338135],[55.3309478759766,26.2336578369141],[55.8957328796387,26.6231632232666],[56.8419570922852,27.032506942749],[56.9238815307617,26.982494354248],[56.9697113037109,27],[56.9710998535156,26.9638824462891],[56.9269409179688,26.95166015625],[57.0213775634766,26.8522186279297],[57.0877685546875,26.6397171020508],[57.0935020446777,26.3846473693848],[57.0930938720703,26.2985668182373],[57.1257934570312,26.2642478942871],[57.2138824462891,26.1724967956543],[57.1672134399414,26.0722198486328],[57.2713775634766,25.9194412231445],[57.3180541992188,25.7708320617676],[57.6260986328125,25.7302742004395],[57.748046875,25.745548248291],[57.7869415283203,25.6983299255371],[57.7769393920898,25.6280517578125],[57.9577713012695,25.7002716064453],[58.0455474853516,25.5769424438477],[58.1349945068359,25.5413856506348],[58.3228645324707,25.5784320831299],[58.4089469909668,25.5911083221436],[58.8183288574219,25.5599975585938],[58.9324951171875,25.504997253418],[59.0258255004883,25.3974952697754],[59.2470016479492,25.4261932373047],[59.4780426025391,25.4772186279297],[59.5991592407227,25.3955497741699],[59.8388824462891,25.4108276367188],[59.8938827514648,25.3449974060059],[60.0711059570312,25.3791618347168],[60.1824951171875,25.3211097717285],[60.1969375610352,25.3652725219727],[60.2936096191406,25.3783302307129],[60.3072128295898,25.3294410705566],[60.4611053466797,25.2636108398438],[60.3952713012695,25.3755531311035],[60.4549942016602,25.4316635131836],[60.5472183227539,25.4416618347168],[60.6027755737305,25.4002723693848],[60.6222152709961,25.2680549621582],[61.1730499267578,25.1744384765625],[61.2249908447266,25.1186065673828],[61.4385986328125,25.0752754211426],[61.4230499267578,25.0974960327148],[61.4952697753906,25.1152725219727],[61.5166625976562,25.1547164916992],[61.4861068725586,25.1972160339355],[61.5538787841797,25.1974945068359],[61.5497207641602,25.25],[61.6110305786133,25.1976470947266],[61.7822113037109,25.1902732849121],[61.7244338989258,25.0524978637695],[61.8372116088867,25.0344429016113],[61.8619384765625,25.0927734375],[61.911376953125,25.1127738952637],[62.1044387817383,25.1016616821289],[62.0777740478516,25.1813850402832],[62.1677703857422,25.2163848876953],[62.2952728271484,25.199161529541],[62.3191604614258,25.1427726745605],[62.2816619873047,25.1049957275391],[62.3530502319336,25.0919418334961],[62.3911056518555,25.1022186279297],[62.3363800048828,25.1277732849121],[62.3622131347656,25.1733283996582],[62.4855499267578,25.2094383239746],[62.4644393920898,25.2363815307617],[62.5269393920898,25.2555541992188],[62.7447128295898,25.2594413757324],[63.0080490112305,25.2147178649902],[63.1558227539062,25.2563858032227],[63.504997253418,25.188606262207],[63.5236053466797,25.2136077880859],[63.4699859619141,25.2802772521973],[63.5724945068359,25.3599967956543],[63.7486038208008,25.3852729797363],[63.9291610717773,25.3341636657715],[64.06298828125,25.3367881774902],[64.0916595458984,25.3286094665527],[64.2555541992188,25.3147201538086],[64.4349822998047,25.2311058044434],[64.5166625976562,25.2694435119629],[64.5927581787109,25.2555541992188],[64.6310882568359,25.2205505371094],[64.6199798583984,25.169994354248],[64.7099914550781,25.1802749633789],[64.6649932861328,25.2094383239746],[64.6677551269531,25.2569427490234],[64.7688751220703,25.3213844299316],[65.1397094726562,25.2877769470215],[65.2541656494141,25.3774948120117],[65.3861083984375,25.390552520752],[65.3877716064453,25.3624954223633],[65.4664154052734,25.3826751708984],[65.6677551269531,25.3427734375],[65.8466491699219,25.4166641235352],[66.2638854980469,25.4677734375],[66.4957733154297,25.398120880127],[66.5463714599609,25.3628978729248],[66.7327575683594,25.1974945068359],[66.6741485595703,24.9338836669922],[66.7049865722656,24.8916625976562],[66.6502685546875,24.8261070251465],[66.8594207763672,24.8544425964355],[66.9510955810547,24.8047180175781],[66.9608154296875,24.8386077880859],[67.0728302001953,24.767599105835],[67.1467895507812,24.6440982818604],[67.1563720703125,24.6074981689453],[67.2516632080078,24.5891647338867],[67.1816558837891,24.579719543457],[67.2297058105469,24.5330543518066],[67.2136077880859,24.5036087036133],[67.2572174072266,24.4136085510254],[67.2855377197266,24.4363822937012],[67.2788696289062,24.3569412231445],[67.3594207763672,24.3424949645996],[67.2980346679688,24.3394393920898],[67.2816619873047,24.2808303833008],[67.3632965087891,24.0671463012695],[67.4527740478516,23.9866600036621],[67.5,23.9751287866651],[67.5,23.9091657236755],[67.4824829101562,23.8958282470703],[67.5,23.8845002544088],[67.5,22.5],[52.5206718444824,22.5],],
			},
			"571" => {
				"z" => "Etc/GMT+5",
				"c" => "ESRI",
				"s" => "37,2",
				"p" => [[66.2105407714844,37.5],[67.5,37.5],[67.5,37.2732683853364],[67.4924774169922,37.2808227539062],[67.397216796875,37.2174911499023],[67.2399749755859,37.1861038208008],[67.1863708496094,37.2580490112305],[67.1174774169922,37.2802734375],[67.0964813232422,37.3399658203125],[67.0041656494141,37.382209777832],[66.6722106933594,37.3383255004883],[66.5377349853516,37.3663787841797],[66.4474792480469,37.318603515625],[66.4083251953125,37.3460998535156],[66.2899780273438,37.3247146606445],[66.0905456542969,37.4316635131836],[65.8602261185859,37.5],[65.6719705175223,37.5],[65.6444396972656,37.4488754272461],[65.6508178710938,37.3555526733398],[65.5544281005859,37.2563858032227],[65.0727691650391,37.2444381713867],[64.8230438232422,37.1386032104492],[64.7791595458984,37.0958251953125],[64.7952575683594,36.9230499267578],[64.6169281005859,36.6363830566406],[64.6152648925781,36.4236068725586],[64.473876953125,36.2555541992188],[64.3366546630859,36.2247085571289],[64.2824859619141,36.1519317626953],[64.1813659667969,36.1705474853516],[64.0949859619141,36.1233215332031],[64.0597076416016,36.0880432128906],[64.0638732910156,36.0002746582031],[63.9205474853516,36.0374984741211],[63.7783279418945,35.9805450439453],[63.6011047363281,35.9644393920898],[63.5283279418945,35.9049911499023],[63.3424911499023,35.8572158813477],[63.1194381713867,35.8619384765625],[63.1297149658203,35.7752685546875],[63.2400207519531,35.6992797851562],[63.0952682495117,35.6260986328125],[63.1266555786133,35.5336074829102],[63.1052703857422,35.4508285522461],[62.922492980957,35.384162902832],[62.7222137451172,35.2547149658203],[62.5544357299805,35.2336044311523],[62.4649963378906,35.2886047363281],[62.3091583251953,35.1416625976562],[62.2694396972656,35.2858276367188],[62.1325607299805,35.3680572509766],[61.9958267211914,35.4583282470703],[61.802490234375,35.4111022949219],[61.5958251953125,35.4441528320312],[61.4060974121094,35.5638809204102],[61.3788757324219,35.6352691650391],[61.2765579223633,35.6072463989258],[61.228874206543,35.6780471801758],[61.2622146606445,35.8197174072266],[61.2258224487305,35.9038772583008],[61.1242828369141,35.9756546020508],[61.1699905395508,35.9952697753906],[61.1647109985352,36.035270690918],[61.2291564941406,36.1266555786133],[61.1844329833984,36.2866592407227],[61.1502685546875,36.3149948120117],[61.1899871826172,36.5677719116211],[61.1572113037109,36.6499938964844],[60.3330535888672,36.6560974121094],[60.2784042358398,36.7627182006836],[60.0294342041016,37.0369415283203],[59.9147109985352,37.0586013793945],[59.8130493164062,37.1247100830078],[59.6705474853516,37.1560974121094],[59.6202697753906,37.1319351196289],[59.5669403076172,37.2088851928711],[59.476936340332,37.218879699707],[59.4913787841797,37.2483291625977],[59.3930511474609,37.3230514526367],[59.3808212280273,37.4855499267578],[59.3695173924485,37.5],[54.7601060656409,37.5],[54.6811065673828,37.443603515625],[54.5516586303711,37.4460983276367],[54.2316589355469,37.3272171020508],[53.9056396484375,37.3508529663086],[54.0158309936523,37.0219345092773],[53.9883270263672,36.9822082519531],[54.0316619873047,36.9483261108398],[54.0286026000977,36.8247146606445],[53.9433212280273,36.7999954223633],[53.6819381713867,36.8172149658203],[53.6338806152344,36.8480453491211],[53.661376953125,36.8577728271484],[53.6074981689453,36.8683242797852],[53.984992980957,36.8986053466797],[54.0086059570312,36.9483261108398],[53.9227676391602,36.9097137451172],[53.2230453491211,36.8483276367188],[52.5,36.6931488869617],[52.5,37.5],[59.4797134399414,37.5],[66.2105407714844,37.5],],
			},
			"577" => {
				"z" => "Etc/GMT+5",
				"c" => "ESRI",
				"s" => "37,3",
				"p" => [[67.5,24.2394371032715],[67.5,23.8845002544088],[67.4824829101562,23.8958282470703],[67.5,23.9091657236755],[67.5,23.9751287866651],[67.4527740478516,23.9866600036621],[67.3632965087891,24.0671463012695],[67.2816619873047,24.2808303833008],[67.2980346679688,24.3394393920898],[67.3594207763672,24.3424949645996],[67.2788696289062,24.3569412231445],[67.2855377197266,24.4363822937012],[67.2572174072266,24.4136085510254],[67.2136077880859,24.5036087036133],[67.2297058105469,24.5330543518066],[67.1816558837891,24.579719543457],[67.2516632080078,24.5891647338867],[67.1563720703125,24.6074981689453],[67.1467895507812,24.6440982818604],[67.0728302001953,24.767599105835],[66.9608154296875,24.8386077880859],[66.9510955810547,24.8047180175781],[66.8594207763672,24.8544425964355],[66.6502685546875,24.8261070251465],[66.7049865722656,24.8916625976562],[66.6741485595703,24.9338836669922],[66.7327575683594,25.1974945068359],[66.5463714599609,25.3628978729248],[66.4957733154297,25.398120880127],[66.2638854980469,25.4677734375],[65.8466491699219,25.4166641235352],[65.6677551269531,25.3427734375],[65.4664154052734,25.3826751708984],[65.3877716064453,25.3624954223633],[65.3861083984375,25.390552520752],[65.2541656494141,25.3774948120117],[65.1397094726562,25.2877769470215],[64.7688751220703,25.3213844299316],[64.6677551269531,25.2569427490234],[64.6649932861328,25.2094383239746],[64.7099914550781,25.1802749633789],[64.6199798583984,25.169994354248],[64.6310882568359,25.2205505371094],[64.5927581787109,25.2555541992188],[64.5166625976562,25.2694435119629],[64.4349822998047,25.2311058044434],[64.2555541992188,25.3147201538086],[64.0916595458984,25.3286094665527],[64.06298828125,25.3367881774902],[63.9291610717773,25.3341636657715],[63.7486038208008,25.3852729797363],[63.5724945068359,25.3599967956543],[63.4699859619141,25.2802772521973],[63.5236053466797,25.2136077880859],[63.504997253418,25.188606262207],[63.1558227539062,25.2563858032227],[63.0080490112305,25.2147178649902],[62.7447128295898,25.2594413757324],[62.5269393920898,25.2555541992188],[62.4644393920898,25.2363815307617],[62.4855499267578,25.2094383239746],[62.3622131347656,25.1733283996582],[62.3363800048828,25.1277732849121],[62.3911056518555,25.1022186279297],[62.3530502319336,25.0919418334961],[62.2816619873047,25.1049957275391],[62.3191604614258,25.1427726745605],[62.2952728271484,25.199161529541],[62.1677703857422,25.2163848876953],[62.0777740478516,25.1813850402832],[62.1044387817383,25.1016616821289],[61.911376953125,25.1127738952637],[61.8619384765625,25.0927734375],[61.8372116088867,25.0344429016113],[61.7244338989258,25.0524978637695],[61.7822113037109,25.1902732849121],[61.6110305786133,25.1976470947266],[61.6469421386719,25.3061065673828],[61.6686019897461,25.6327743530273],[61.7036056518555,25.6766624450684],[61.6863784790039,25.7949981689453],[61.7758255004883,25.8186073303223],[61.8441543579102,26.2116622924805],[61.8760986328125,26.2463836669922],[62.1038818359375,26.3144416809082],[62.1288757324219,26.3444404602051],[62.1358261108398,26.3808288574219],[62.2780303955078,26.3540229797363],[62.2713775634766,26.4247169494629],[62.3202743530273,26.5152740478516],[62.4460983276367,26.5688858032227],[62.743049621582,26.6116638183594],[62.7727661132812,26.6497192382812],[63.176383972168,26.6311073303223],[63.2063827514648,26.8422203063965],[63.2905502319336,26.892219543457],[63.259162902832,26.934440612793],[63.2530517578125,27.0836067199707],[63.2786026000977,27.121940612793],[63.3419342041016,27.1224975585938],[63.288330078125,27.2186050415039],[63.2058258056641,27.2674980163574],[62.9333267211914,27.2133293151855],[62.8230514526367,27.2302742004395],[62.7647171020508,27.2719421386719],[62.7958297729492,27.2855529785156],[62.8069381713867,27.3233299255371],[62.7783279418945,27.353328704834],[62.839714050293,27.474437713623],[62.8219375610352,27.7602767944336],[62.7577743530273,28.0002746582031],[62.781379699707,28.2669410705566],[62.5924911499023,28.2336044311523],[62.4049911499023,28.4172172546387],[61.9055480957031,28.5549964904785],[61.5813827514648,28.8808288574219],[61.5336074829102,29.0124969482422],[61.4880447387695,29.0436096191406],[61.5111083984375,29.0886077880859],[61.4247131347656,29.1552734375],[61.3602752685547,29.2658309936523],[61.3586044311523,29.3844413757324],[61.3144378662109,29.3958282470703],[60.8663024902344,29.863655090332],[62.4844360351562,29.4061050415039],[63.5872116088867,29.5038871765137],[64.1222076416016,29.3886070251465],[64.2113800048828,29.4986038208008],[64.4785919189453,29.5730514526367],[64.6955261230469,29.5863838195801],[65.0341491699219,29.5411071777344],[66.2566528320312,29.8519401550293],[66.3621978759766,29.9561042785645],[66.2383117675781,30.0713844299316],[66.3252716064453,30.2377738952637],[66.3516540527344,30.4452743530273],[66.2819366455078,30.5752754211426],[66.3955383300781,30.9408302307129],[66.5727691650391,30.9813842773438],[66.6841430664062,31.086109161377],[66.7230377197266,31.212215423584],[66.7930450439453,31.2197151184082],[66.8416595458984,31.2724990844727],[66.9569396972656,31.3180541992188],[67.0427551269531,31.3163871765137],[67.0558166503906,31.243049621582],[67.2564849853516,31.2223243713379],[67.3847198486328,31.2152709960938],[67.5,31.2508945801717],[67.5,25.7141609191895],[67.5,24.2394371032715],],
			},
			"7" => {
				"z" => "Asia/Kabul",
				"c" => "ESRI",
				"s" => "2,1",
				"p" => [[67.5,34.0088882446289],[67.5,31.2508945801717],[67.3847198486328,31.2152709960938],[67.2564849853516,31.2223243713379],[67.0558166503906,31.243049621582],[67.0427551269531,31.3163871765137],[66.9569396972656,31.3180541992188],[66.8416595458984,31.2724990844727],[66.7930450439453,31.2197151184082],[66.7230377197266,31.212215423584],[66.6841430664062,31.086109161377],[66.5727691650391,30.9813842773438],[66.3955383300781,30.9408302307129],[66.2819366455078,30.5752754211426],[66.3516540527344,30.4452743530273],[66.3252716064453,30.2377738952637],[66.2383117675781,30.0713844299316],[66.3621978759766,29.9561042785645],[66.2566528320312,29.8519401550293],[65.0341491699219,29.5411071777344],[64.6955261230469,29.5863838195801],[64.4785919189453,29.5730514526367],[64.2113800048828,29.4986038208008],[64.1222076416016,29.3886070251465],[63.5872116088867,29.5038871765137],[62.4844360351562,29.4061050415039],[60.8663024902344,29.863655090332],[61.7865219116211,30.8095283508301],[61.8040237426758,30.9451332092285],[61.8511047363281,31.021110534668],[61.7646560668945,31.2447700500488],[61.7711029052734,31.3183288574219],[61.7136077880859,31.3833312988281],[61.1041641235352,31.4630508422852],[60.843879699707,31.4983291625977],[60.7969436645508,32.0374984741211],[60.8366546630859,32.0902709960938],[60.8577728271484,32.2347183227539],[60.5805511474609,33.0886001586914],[60.5911026000977,33.1630477905273],[60.8516616821289,33.4180526733398],[60.8544387817383,33.489990234375],[60.9430465698242,33.5194396972656],[60.8863830566406,33.5572128295898],[60.6660995483398,33.567497253418],[60.5277709960938,33.644157409668],[60.5052719116211,33.7391586303711],[60.5541610717773,33.8133239746094],[60.5044403076172,34.1222152709961],[60.5461044311523,34.1963806152344],[60.6755523681641,34.288330078125],[60.6655426025391,34.3124923706055],[60.9152679443359,34.3199920654297],[60.7216567993164,34.522216796875],[60.9713745117188,34.6444396972656],[60.9833297729492,34.7338790893555],[61.0630493164062,34.8088836669922],[61.0697174072266,34.9288787841797],[61.1424942016602,35.0983276367188],[61.0947113037109,35.1841583251953],[61.1044387817383,35.2791595458984],[61.1927642822266,35.3058242797852],[61.1944351196289,35.402214050293],[61.2877731323242,35.5499954223633],[61.2765579223633,35.6072463989258],[61.3788757324219,35.6352691650391],[61.4060974121094,35.5638809204102],[61.5958251953125,35.4441528320312],[61.802490234375,35.4111022949219],[61.9958267211914,35.4583282470703],[62.1325607299805,35.3680572509766],[62.2694396972656,35.2858276367188],[62.3091583251953,35.1416625976562],[62.4649963378906,35.2886047363281],[62.5544357299805,35.2336044311523],[62.7222137451172,35.2547149658203],[62.922492980957,35.384162902832],[63.1052703857422,35.4508285522461],[63.1266555786133,35.5336074829102],[63.0952682495117,35.6260986328125],[63.2400207519531,35.6992797851562],[63.1297149658203,35.7752685546875],[63.1194381713867,35.8619384765625],[63.3424911499023,35.8572158813477],[63.5283279418945,35.9049911499023],[63.6011047363281,35.9644393920898],[63.7783279418945,35.9805450439453],[63.9205474853516,36.0374984741211],[64.0638732910156,36.0002746582031],[64.0597076416016,36.0880432128906],[64.0949859619141,36.1233215332031],[64.1813659667969,36.1705474853516],[64.2824859619141,36.1519317626953],[64.3366546630859,36.2247085571289],[64.473876953125,36.2555541992188],[64.6152648925781,36.4236068725586],[64.6169281005859,36.6363830566406],[64.7952575683594,36.9230499267578],[64.7791595458984,37.0958251953125],[64.8230438232422,37.1386032104492],[65.0727691650391,37.2444381713867],[65.5544281005859,37.2563858032227],[65.6508178710938,37.3555526733398],[65.6444396972656,37.4488754272461],[65.6719705175223,37.5],[65.8602261185859,37.5],[66.0905456542969,37.4316635131836],[66.2899780273438,37.3247146606445],[66.4083251953125,37.3460998535156],[66.4474792480469,37.318603515625],[66.5377349853516,37.3663787841797],[66.6722106933594,37.3383255004883],[67.0041656494141,37.382209777832],[67.0964813232422,37.3399658203125],[67.1174774169922,37.2802734375],[67.1863708496094,37.2580490112305],[67.2399749755859,37.1861038208008],[67.397216796875,37.2174911499023],[67.4924774169922,37.2808227539062],[67.5,37.2732683853364],[67.5,36.4655532836914],[67.5,34.0088882446289],],
			},
		},
		# Grid 4:3 ; 4 records
		"3" => {
			"358" => {
				"z" => "Etc/GMT+6",
				"c" => "ESRI",
				"s" => "21,2",
				"p" => [[67.5,41.7821655273438],[67.5,39.183172292618],[67.3763732910156,39.2124938964844],[67.3660888671875,39.2936096191406],[67.4105377197266,39.2991638183594],[67.4419555664062,39.4835815429688],[67.2980346679688,39.5861053466797],[67.29248046875,39.6655426025391],[67.37109375,39.6877670288086],[67.3813629150391,39.7805480957031],[67.5,39.8142815638854],[67.5,39.8364390491483],[67.4797058105469,39.9319381713867],[67.1055450439453,39.9861068725586],[67.0236053466797,40.0327682495117],[67.0347137451172,40.0688858032227],[66.9421997070312,40.0633239746094],[66.9347076416016,40.1249923706055],[66.97998046875,40.1738815307617],[66.9085998535156,40.248046875],[66.8883209228516,40.4783248901367],[66.6200256347656,40.4950790405273],[66.8052520751953,40.7661056518555],[66.7663879394531,40.8874969482422],[66.6324768066406,40.9388809204102],[66.6080322265625,41.1133270263672],[66.7530517578125,41.1169357299805],[66.7594909667969,41.1648330688477],[66.7199859619141,41.1749954223633],[66.5624847412109,41.7169342041016],[66.5263824462891,42.0030517578125],[66.0291595458984,42.0030517578125],[66.0366516113281,42.4233245849609],[66.0707855224609,42.4238662719727],[66.2188720703125,42.4236068725586],[67.0160980224609,42.8661041259766],[67.5,43.0940928261085],[67.5,44.3570303550694],[67.4788665771484,44.3636093139648],[67.5,44.3949313672658],[67.5,45.1625382638568],[67.3627624511719,45.1791610717773],[67.1783294677734,45.2934112548828],[67.2494201660156,45.4577713012695],[67.2533264160156,45.5838775634766],[67.3583221435547,45.7711029052734],[67.3144226074219,45.8472137451172],[67.1819305419922,45.9411010742188],[67.1698760986328,45.9989700317383],[67.1577606201172,46.1294326782227],[67.1216888427734,46.1655120849609],[66.5355377197266,46.1427688598633],[65.6294250488281,46.1816635131836],[65.2763824462891,46.3630523681641],[65.119140625,46.4808197021484],[64.9702606201172,46.4727630615234],[64.3888854980469,46.6966552734375],[63.4180526733398,46.9202728271484],[63.0861053466797,47.089714050293],[62.6930541992188,47.0425643920898],[62.851921081543,47.1388854980469],[63.1424942016602,47.2849960327148],[63.1952667236328,47.3408279418945],[64.0160980224609,47.7216567993164],[64.2891540527344,47.8883285522461],[64.1344299316406,47.984992980957],[64.01220703125,48.1569366455078],[63.9155426025391,48.2338790893555],[63.7611083984375,48.4508285522461],[63.4708251953125,48.5358276367188],[63.4149932861328,48.5924911499023],[63.0941543579102,48.6794357299805],[63.0569381713867,48.7224884033203],[63.1005477905273,48.8605499267578],[62.9760971069336,48.9119338989258],[62.8472137451172,48.8433227539062],[62.5652694702148,49.0108261108398],[62.4624938964844,49.176383972168],[62.3361053466797,49.1997146606445],[62.3566589355469,49.2594375610352],[62.5449981689453,49.251106262207],[62.3502731323242,49.4694366455078],[62.3030471801758,49.4863815307617],[62.3736038208008,49.5683288574219],[62.4841613769531,49.5480499267578],[62.4544372558594,49.6788787841797],[62.5969390869141,49.7799911499023],[62.57666015625,49.8527755737305],[62.7386016845703,49.9477691650391],[62.9044342041016,49.894157409668],[62.9408264160156,49.9913787841797],[62.8641586303711,50.097770690918],[62.7102737426758,50.2122116088867],[62.6983261108398,50.2830505371094],[62.5083312988281,50.4680480957031],[62.3824920654297,50.7224884033203],[62.2544403076172,50.6824951171875],[62.1891555786133,50.7099914550781],[62.2358245849609,50.7413787841797],[62.1927642822266,50.8044357299805],[62.4252700805664,50.8569412231445],[62.7838821411133,50.8605499267578],[62.8683242797852,50.8211059570312],[62.9399871826172,50.8655471801758],[63.1319351196289,50.8222198486328],[63.2019348144531,50.8772125244141],[63.2649993896484,50.8263854980469],[63.8141555786133,50.9385986328125],[64.0994262695312,51.0391616821289],[64.3491516113281,50.8774871826172],[64.2588806152344,50.7505493164062],[64.1874847412109,50.7336044311523],[64.0599822998047,50.5774917602539],[64.2255401611328,50.51416015625],[64.25,50.5405502319336],[64.3646087646484,50.5110931396484],[64.3894348144531,50.5516586303711],[64.4783630371094,50.5819396972656],[64.4724884033203,50.6330490112305],[64.5621948242188,50.6788787841797],[64.6041564941406,50.6513824462891],[64.6927490234375,50.6711044311523],[64.7302703857422,50.7380447387695],[64.8138732910156,50.7863845825195],[64.9155426025391,51.0080490112305],[64.8194427490234,51.0722198486328],[64.8497161865234,51.0966567993164],[64.9141540527344,51.1397171020508],[64.9777679443359,51.1033248901367],[65.2058258056641,51.1733245849609],[65.2949829101562,51.1647109985352],[65.4069366455078,51.2316589355469],[65.3035888671875,51.2822113037109],[65.2160949707031,51.2488784790039],[65.1316528320312,51.281379699707],[64.8841552734375,51.4702682495117],[64.9544372558594,51.5269393920898],[64.9424743652344,51.6130523681641],[65.0113830566406,51.6377716064453],[64.957763671875,51.7494354248047],[65.0166625976562,51.8233261108398],[65.0088806152344,51.8924942016602],[64.9249877929688,51.9088821411133],[64.8060913085938,52.0255508422852],[64.8013763427734,52.1244354248047],[64.7488708496094,52.1283264160156],[64.7516632080078,52.1816635131836],[65.05859375,52.2316589355469],[65.0449829101562,52.2802734375],[65.4608154296875,52.29638671875],[65.584716796875,52.3277740478516],[65.5841522216797,52.3897171020508],[66.0288696289062,52.4530487060547],[66.0319014630981,52.5],[67.5,52.5],[67.5,43.1413497924805],[67.5,41.7821655273438],],
			},
			"572" => {
				"z1" => "57.1813889,50.2980556,Asia/Aqtobe",
				"z0" => "58.3833333,37.95,Asia/Ashgabat",
				"z2" => "65.5091667,44.8527778,Asia/Qyzylorda",
				"c" => "ESRI",
				"s" => "37,2",
				"p" => [[66.2105407714844,52.5],[66.0319014630981,52.5],[66.0288696289062,52.4530487060547],[65.5841522216797,52.3897171020508],[65.584716796875,52.3277740478516],[65.4608154296875,52.29638671875],[65.0449829101562,52.2802734375],[65.05859375,52.2316589355469],[64.7516632080078,52.1816635131836],[64.7488708496094,52.1283264160156],[64.8013763427734,52.1244354248047],[64.8060913085938,52.0255508422852],[64.9249877929688,51.9088821411133],[65.0088806152344,51.8924942016602],[65.0166625976562,51.8233261108398],[64.957763671875,51.7494354248047],[65.0113830566406,51.6377716064453],[64.9424743652344,51.6130523681641],[64.9544372558594,51.5269393920898],[64.8841552734375,51.4702682495117],[65.1316528320312,51.281379699707],[65.2160949707031,51.2488784790039],[65.3035888671875,51.2822113037109],[65.4069366455078,51.2316589355469],[65.2949829101562,51.1647109985352],[65.2058258056641,51.1733245849609],[64.9777679443359,51.1033248901367],[64.9141540527344,51.1397171020508],[64.8497161865234,51.0966567993164],[64.8194427490234,51.0722198486328],[64.9155426025391,51.0080490112305],[64.8138732910156,50.7863845825195],[64.7302703857422,50.7380447387695],[64.6927490234375,50.6711044311523],[64.6041564941406,50.6513824462891],[64.5621948242188,50.6788787841797],[64.4724884033203,50.6330490112305],[64.4783630371094,50.5819396972656],[64.3894348144531,50.5516586303711],[64.3646087646484,50.5110931396484],[64.25,50.5405502319336],[64.2255401611328,50.51416015625],[64.0599822998047,50.5774917602539],[64.1874847412109,50.7336044311523],[64.2588806152344,50.7505493164062],[64.3491516113281,50.8774871826172],[64.0994262695312,51.0391616821289],[63.8141555786133,50.9385986328125],[63.2649993896484,50.8263854980469],[63.2019348144531,50.8772125244141],[63.1319351196289,50.8222198486328],[62.9399871826172,50.8655471801758],[62.8683242797852,50.8211059570312],[62.7838821411133,50.8605499267578],[62.4252700805664,50.8569412231445],[62.1927642822266,50.8044357299805],[62.2358245849609,50.7413787841797],[62.1891555786133,50.7099914550781],[62.2544403076172,50.6824951171875],[62.3824920654297,50.7224884033203],[62.5083312988281,50.4680480957031],[62.6983261108398,50.2830505371094],[62.7102737426758,50.2122116088867],[62.8641586303711,50.097770690918],[62.9408264160156,49.9913787841797],[62.9044342041016,49.894157409668],[62.7386016845703,49.9477691650391],[62.57666015625,49.8527755737305],[62.5969390869141,49.7799911499023],[62.4544372558594,49.6788787841797],[62.4841613769531,49.5480499267578],[62.3736038208008,49.5683288574219],[62.3030471801758,49.4863815307617],[62.3502731323242,49.4694366455078],[62.5449981689453,49.251106262207],[62.3566589355469,49.2594375610352],[62.3361053466797,49.1997146606445],[62.4624938964844,49.176383972168],[62.5652694702148,49.0108261108398],[62.8472137451172,48.8433227539062],[62.9760971069336,48.9119338989258],[63.1005477905273,48.8605499267578],[63.0569381713867,48.7224884033203],[63.0941543579102,48.6794357299805],[63.4149932861328,48.5924911499023],[63.4708251953125,48.5358276367188],[63.7611083984375,48.4508285522461],[63.9155426025391,48.2338790893555],[64.01220703125,48.1569366455078],[64.1344299316406,47.984992980957],[64.2891540527344,47.8883285522461],[64.0160980224609,47.7216567993164],[63.1952667236328,47.3408279418945],[63.1424942016602,47.2849960327148],[62.851921081543,47.1388854980469],[62.6930541992188,47.0425643920898],[63.0861053466797,47.089714050293],[63.4180526733398,46.9202728271484],[64.3888854980469,46.6966552734375],[64.9702606201172,46.4727630615234],[65.119140625,46.4808197021484],[65.2763824462891,46.3630523681641],[65.6294250488281,46.1816635131836],[66.5355377197266,46.1427688598633],[67.1216888427734,46.1655120849609],[67.1577606201172,46.1294326782227],[67.1698760986328,45.9989700317383],[67.1819305419922,45.9411010742188],[67.3144226074219,45.8472137451172],[67.3583221435547,45.7711029052734],[67.2533264160156,45.5838775634766],[67.2494201660156,45.4577713012695],[67.1783294677734,45.2934112548828],[67.3627624511719,45.1791610717773],[67.5,45.1625382638568],[67.5,44.3949313672658],[67.4788665771484,44.3636093139648],[67.5,44.3570303550694],[67.5,43.0940928261085],[67.0160980224609,42.8661041259766],[66.2188720703125,42.4236068725586],[66.0707855224609,42.4238662719727],[66.0366516113281,42.4233245849609],[66.0291595458984,42.0030517578125],[66.5263824462891,42.0030517578125],[66.5624847412109,41.7169342041016],[66.7199859619141,41.1749954223633],[66.7594909667969,41.1648330688477],[66.7530517578125,41.1169357299805],[66.6080322265625,41.1133270263672],[66.6324768066406,40.9388809204102],[66.7663879394531,40.8874969482422],[66.8052520751953,40.7661056518555],[66.6200256347656,40.4950790405273],[66.8883209228516,40.4783248901367],[66.9085998535156,40.248046875],[66.97998046875,40.1738815307617],[66.9347076416016,40.1249923706055],[66.9421997070312,40.0633239746094],[67.0347137451172,40.0688858032227],[67.0236053466797,40.0327682495117],[67.1055450439453,39.9861068725586],[67.4797058105469,39.9319381713867],[67.5,39.8364390491483],[67.5,39.8142815638854],[67.3813629150391,39.7805480957031],[67.37109375,39.6877670288086],[67.29248046875,39.6655426025391],[67.2980346679688,39.5861053466797],[67.4419555664062,39.4835815429688],[67.4105377197266,39.2991638183594],[67.3660888671875,39.2936096191406],[67.3763732910156,39.2124938964844],[67.5,39.183172292618],[67.5,37.5],[65.8602261185859,37.5],[65.8452606201172,37.5044403076172],[65.7816772460938,37.5715026855469],[65.7719268798828,37.5374984741211],[65.6810913085938,37.5169372558594],[65.6719705175223,37.5],[59.3695173924485,37.5],[59.3388824462891,37.5391616821289],[59.25,37.5133285522461],[59.0602722167969,37.6299896240234],[58.8227691650391,37.7036056518555],[58.8044357299805,37.6669387817383],[58.7127685546875,37.6486053466797],[58.5624923706055,37.7086029052734],[58.498046875,37.6477737426758],[58.38916015625,37.6361083984375],[58.2274856567383,37.6811065673828],[58.2030487060547,37.783332824707],[58.1744384765625,37.79638671875],[58.0469436645508,37.8094329833984],[57.7080459594727,37.9266586303711],[57.4502716064453,37.9391555786133],[57.3530502319336,37.9894332885742],[57.3711013793945,38.0930480957031],[57.288330078125,38.1705474853516],[57.2438812255859,38.2708282470703],[57.2047119140625,38.283332824707],[57.1888809204102,38.283332824707],[57.149787902832,38.2600936889648],[57.0586013793945,38.193603515625],[56.8458251953125,38.2316589355469],[56.755744934082,38.286262512207],[56.613883972168,38.2405471801758],[56.4427642822266,38.2599945068359],[56.3224945068359,38.1852645874023],[56.3527755737305,38.1388854980469],[56.3330535888672,38.0855484008789],[56.2230453491211,38.0702743530273],[56.164436340332,38.0949935913086],[55.9827651977539,38.0724945068359],[55.756103515625,38.1252670288086],[55.4427642822266,38.0861053466797],[55.2102737426758,37.9622116088867],[55.1408309936523,37.9561004638672],[54.9547119140625,37.8049926757812],[54.8330535888672,37.7463836669922],[54.7822113037109,37.6480484008789],[54.8097152709961,37.5794372558594],[54.7869415283203,37.519157409668],[54.7601060656409,37.5],[52.5,37.5],[52.5,52.5],[59.4797134399414,52.5],[66.2105407714844,52.5],],
			},
			"6" => {
				"z" => "Asia/Tehran",
				"c" => "ESRI",
				"s" => "1,1",
				"p" => [[62.839714050293,37.5],[52.5,37.5],[54.7601060656409,37.5],[54.7869415283203,37.519157409668],[54.8097152709961,37.5794372558594],[54.7822113037109,37.6480484008789],[54.8330535888672,37.7463836669922],[54.9547119140625,37.8049926757812],[55.1408309936523,37.9561004638672],[55.2102737426758,37.9622116088867],[55.4427642822266,38.0861053466797],[55.756103515625,38.1252670288086],[55.9827651977539,38.0724945068359],[56.164436340332,38.0949935913086],[56.2230453491211,38.0702743530273],[56.3330535888672,38.0855484008789],[56.3527755737305,38.1388854980469],[56.3224945068359,38.1852645874023],[56.4427642822266,38.2599945068359],[56.613883972168,38.2405471801758],[56.755744934082,38.286262512207],[56.8458251953125,38.2316589355469],[57.0586013793945,38.193603515625],[57.149787902832,38.2600936889648],[57.1888809204102,38.283332824707],[57.2047119140625,38.283332824707],[57.2438812255859,38.2708282470703],[57.288330078125,38.1705474853516],[57.3711013793945,38.0930480957031],[57.3530502319336,37.9894332885742],[57.4502716064453,37.9391555786133],[57.7080459594727,37.9266586303711],[58.0469436645508,37.8094329833984],[58.1744384765625,37.79638671875],[58.2030487060547,37.783332824707],[58.2274856567383,37.6811065673828],[58.38916015625,37.6361083984375],[58.498046875,37.6477737426758],[58.5624923706055,37.7086029052734],[58.7127685546875,37.6486053466797],[58.8044357299805,37.6669387817383],[58.8227691650391,37.7036056518555],[59.0602722167969,37.6299896240234],[59.25,37.5133285522461],[59.3388824462891,37.5391616821289],[59.3695173924485,37.5],[60.5044403076172,37.5],[62.839714050293,37.5],],
			},
			"8" => {
				"z" => "Asia/Kabul",
				"c" => "ESRI",
				"s" => "2,1",
				"p" => [[65.6719705175223,37.5],[65.6810913085938,37.5169372558594],[65.7719268798828,37.5374984741211],[65.7816772460938,37.5715026855469],[65.8452606201172,37.5044403076172],[65.8602261185859,37.5],[67.5,37.5],[60.5044403076172,37.5],[65.6719705175223,37.5],],
			},
		},
		# Grid 4:4 ; 3 records
		"4" => {
			"332" => {
				"z" => "Asia/Kamchatka",
				"c" => "ESRI",
				"s" => "20,1",
				"p" => [[66.2105407714844,67.5],[66.0920715663487,67.5],[66.1066436767578,67.4785919189453],[65.9613800048828,67.395263671875],[65.6905364990234,67.3866577148438],[65.6724853515625,67.3660888671875],[65.7188720703125,67.3405456542969],[65.6588745117188,67.3060913085938],[65.1824798583984,67.1508178710938],[65.2213745117188,67.0769348144531],[65.0705413818359,67.0394287109375],[65.1055450439453,67.0080413818359],[65.1013793945312,66.8905487060547],[64.5760955810547,66.7991485595703],[64.5399780273438,66.7272033691406],[64.4127655029297,66.723876953125],[64.3124847412109,66.6644287109375],[63.9827651977539,66.6535949707031],[63.815544128418,66.5472106933594],[63.6588821411133,66.5258178710938],[63.5372161865234,66.4602661132812],[63.4091567993164,66.4810943603516],[63.4085998535156,66.4527740478516],[63.2233200073242,66.3263854980469],[63.3041610717773,66.2747039794922],[63.2905502319336,66.2327575683594],[63.1538772583008,66.2674865722656],[63.0469436645508,66.2247009277344],[62.9591598510742,66.1097106933594],[62.8616638183594,66.0772094726562],[62.817497253418,66.0119323730469],[62.8883285522461,65.97998046875],[62.7977752685547,65.9310913085938],[62.8611068725586,65.8780364990234],[62.73193359375,65.8577575683594],[62.6938781738281,65.8633117675781],[62.6819381713867,65.863037109375],[62.1130523681641,65.7208251953125],[61.8702697753906,65.7022094726562],[61.6869354248047,65.5738830566406],[61.5822143554688,65.5516510009766],[61.4155426025391,65.3963775634766],[61.2491607666016,65.3188781738281],[61.3336029052734,65.2888793945312],[61.2394332885742,65.1855316162109],[61.1116638183594,65.1722106933594],[60.9627685546875,65.0416564941406],[60.8119354248047,65.0485992431641],[60.6313781738281,64.8836059570312],[60.5963821411133,64.9419250488281],[60.4297180175781,65.0008239746094],[60.427490234375,65.0519256591797],[60.1580429077148,65.0672149658203],[59.6541595458984,64.7833251953125],[59.6380462646484,64.723876953125],[59.7024917602539,64.6516571044922],[59.6136093139648,64.6227569580078],[59.4797134399414,64.48193359375],[59.6047134399414,64.4602661132812],[59.6361083984375,64.3374938964844],[59.5794372558594,64.2794342041016],[59.5880432128906,64.2324829101562],[59.7338790893555,64.1533203125],[59.8597183227539,64.1374969482422],[59.7705459594727,63.9994354248047],[59.5658264160156,63.9191589355469],[59.5724945068359,63.8366546630859],[59.5138854980469,63.7799911499023],[59.4777679443359,63.5680541992188],[59.3172149658203,63.3988800048828],[59.3522186279297,63.3630523681641],[59.2824935913086,63.3327713012695],[59.3386001586914,63.2899932861328],[59.2588882446289,63.2011032104492],[59.3027725219727,63.1263809204102],[59.2222137451172,63.0738830566406],[59.2766571044922,62.9666595458984],[59.4247131347656,62.9441528320312],[59.4872131347656,62.8977737426758],[59.460823059082,62.7791595458984],[59.3913803100586,62.7297134399414],[59.5097198486328,62.5472183227539],[59.6505432128906,62.5172119140625],[59.60888671875,62.4533233642578],[59.584716796875,62.4149932861328],[59.6002731323242,62.3669357299805],[59.5152740478516,62.3172149658203],[59.4044342041016,62.142219543457],[59.4855499267578,61.9880447387695],[59.3413772583008,61.8569412231445],[59.3391571044922,61.8022155761719],[59.3969421386719,61.7611083984375],[59.348876953125,61.6822128295898],[59.1433258056641,61.6330490112305],[59.0108261108398,61.5447158813477],[58.940544128418,61.5597152709961],[58.8097152709961,61.5055541992188],[57.1799926757812,61.5119400024414],[57.0966567993164,61.4852676391602],[56.6755523681641,61.5277709960938],[56.600830078125,61.5024948120117],[56.5452728271484,61.4288787841797],[56.3886032104492,61.4394302368164],[56.3163833618164,61.3252716064453],[56.3480453491211,61.2938842773438],[56.2902755737305,61.2030487060547],[55.8285751342773,61.2505722045898],[55.7232284545898,61.0814590454102],[55.2792129516602,61.1295928955078],[55.1974716186523,61.0041046142578],[55.0610656738281,61.019401550293],[54.9797134399414,60.863883972168],[53.8655471801758,60.9874954223633],[53.8091583251953,60.847770690918],[53.5738830566406,60.8649978637695],[53.3394317626953,60.8938827514648],[53.3849945068359,61.0338821411133],[52.8766555786133,61.093879699707],[52.7949905395508,60.9443283081055],[52.5,60.9742026367824],[52.5,56.0672230086259],[52.6622085571289,56.0155487060547],[52.728874206543,56.0647125244141],[52.7005462646484,56.1413803100586],[52.8369369506836,56.0922164916992],[52.8544387817383,56.1266555786133],[52.810546875,56.1338806152344],[52.8455429077148,56.1572113037109],[52.8058242797852,56.1819381713867],[52.8169403076172,56.2024917602539],[52.5758285522461,56.2274856567383],[52.5583267211914,56.2624969482422],[52.6363830566406,56.2863845825195],[52.7405471801758,56.3747100830078],[52.7227630615234,56.3913803100586],[52.82666015625,56.3888854980469],[52.9527740478516,56.4416580200195],[52.95166015625,56.4691543579102],[52.825553894043,56.5219345092773],[52.9177703857422,56.501106262207],[52.9444351196289,56.5447158813477],[53.0952682495117,56.5269393920898],[52.9385986328125,56.3669357299805],[52.9805450439453,56.3474884033203],[52.9413757324219,56.3063812255859],[52.9822082519531,56.2808227539062],[52.9561004638672,56.2516632080078],[53.0030517578125,56.2216567993164],[52.9941558837891,56.1883239746094],[53.0419387817383,56.2080459594727],[53.0688858032227,56.1824951171875],[53.047492980957,56.1352691650391],[53.1466598510742,56.1622085571289],[53.2611083984375,56.0855484008789],[53.3449935913086,56.084716796875],[53.3424911499023,56.1474914550781],[53.2588882446289,56.2547149658203],[53.4166641235352,56.2783279418945],[53.5560989379883,56.2438812255859],[53.5449981689453,56.1408309936523],[53.4747085571289,56.1211013793945],[53.3788757324219,55.9897155761719],[53.2869415283203,55.935546875],[53.1824951171875,55.9238815307617],[53.297248840332,55.8525238037109],[53.6384201049805,55.9155197143555],[53.9972152709961,55.850830078125],[53.9702682495117,55.7824935913086],[54.0382080078125,55.8009567260742],[54.0261001586914,55.7566604614258],[54.0952758789062,55.7759246826172],[54.2419357299805,55.6913757324219],[54.1783294677734,55.6227645874023],[53.9963836669922,55.5497207641602],[53.996940612793,55.5002746582031],[53.9333267211914,55.4586029052734],[53.8983306884766,55.3816604614258],[53.7091598510742,55.3336029052734],[53.5999984741211,55.2602767944336],[53.5861053466797,55.2077713012695],[53.3994369506836,55.2210998535156],[53.3380432128906,55.1949920654297],[53.3344345092773,55.1624908447266],[53.1388854980469,55.1438827514648],[53.1413803100586,55.093879699707],[53.2683334350586,55.0533218383789],[53.2669372558594,55.0102767944336],[53.406379699707,54.9972152709961],[53.5141220092773,54.8812026977539],[53.6424942016602,54.9013824462891],[53.5769424438477,54.8149948120117],[53.6077728271484,54.8124923706055],[53.5788803100586,54.7488784790039],[53.6086044311523,54.7113800048828],[53.4105453491211,54.5574951171875],[53.4219360351562,54.4866561889648],[53.3444366455078,54.3869400024414],[53.3613815307617,54.3288803100586],[53.4344329833984,54.269157409668],[53.4130477905273,54.2222137451172],[53.4701995849609,54.0451965332031],[53.4108200073242,54.0269393920898],[53.3719329833984,53.9674911499023],[53.2849960327148,54.0274887084961],[53.272216796875,54.0699920654297],[53.1944351196289,54.0983276367188],[53.060546875,54.0699920654297],[53.0913772583008,54.1205444335938],[53.0336074829102,54.1274871826172],[52.9369354248047,54.2136077880859],[53.1158294677734,54.2494354248047],[53.047492980957,54.3416595458984],[53.0013885498047,54.3124923706055],[53.0294342041016,54.289436340332],[53.0136108398438,54.2680511474609],[52.9291610717773,54.2680511474609],[52.8816604614258,54.2777709960938],[52.9324951171875,54.2880477905273],[52.9230499267578,54.3138809204102],[52.6877670288086,54.3611068725586],[52.6219329833984,54.3411026000977],[52.5374450683594,54.3770751953125],[52.5,54.3968998314337],[52.5,54.4341163177229],[52.5030517578125,54.4519348144531],[52.5,54.4532270265692],[52.5,67.5],[64.5174865722656,67.5],[66.2105407714844,67.5],],
			},
			"359" => {
				"z" => "Etc/GMT+6",
				"c" => "ESRI",
				"s" => "21,2",
				"p" => [[67.5,58.5424957275391],[67.5,52.5],[66.0319014630981,52.5],[66.0524749755859,52.818603515625],[66.1344299316406,52.8199920654297],[66.1436004638672,52.8861083984375],[66.4088745117188,52.9033203125],[66.4127655029297,52.9522171020508],[66.0777740478516,52.9630508422852],[66.0819396972656,53.0627670288086],[66.2035980224609,53.1044387817383],[66.4052581787109,53.0997161865234],[66.4144287109375,53.1686019897461],[66.2663879394531,53.1938781738281],[66.2688751220703,53.2827682495117],[66.2552642822266,53.4855499267578],[66.1116485595703,53.4927673339844],[66.1177520751953,53.6308212280273],[66.1830444335938,53.6824951171875],[66.1649932861328,53.7811050415039],[66.0658111572266,53.7927703857422],[66.0758209228516,53.9152679443359],[66.0361022949219,53.9180526733398],[66.0013885498047,53.9947128295898],[66.2144317626953,54.0769424438477],[66.35693359375,54.0844345092773],[66.2785949707031,54.1902694702148],[66.2061004638672,54.1833267211914],[66.1180419921875,54.2374954223633],[66.2194366455078,54.2805480957031],[66.1535949707031,54.3805465698242],[66.1627655029297,54.4194412231445],[66.1235961914062,54.4449920654297],[66.1519317626953,54.4855499267578],[66.113037109375,54.5424957275391],[66.1083221435547,54.6449966430664],[66.4952545166016,54.7230453491211],[66.7227630615234,54.726936340332],[66.8088684082031,54.7666625976562],[67.2455291748047,54.8066558837891],[67.3227691650391,54.8674926757812],[67.5,54.8585464296573],[67.5,55.1388854980469],[67.5,58.5424957275391],],
			},
			"573" => {
				"z1" => "63.7013889,55.8894444,Asia/Kamchatka",
				"z0" => "60.6,56.85,Asia/Yekaterinburg",
				"z2" => "53.0,54.1166667,Asia/Kamchatka",
				"c" => "ESRI",
				"s" => "37,2",
				"p" => [[67.5,59.4197158813477],[67.5,54.8585464296573],[67.3227691650391,54.8674926757812],[67.2455291748047,54.8066558837891],[66.8088684082031,54.7666625976562],[66.7227630615234,54.726936340332],[66.4952545166016,54.7230453491211],[66.1083221435547,54.6449966430664],[66.113037109375,54.5424957275391],[66.1519317626953,54.4855499267578],[66.1235961914062,54.4449920654297],[66.1627655029297,54.4194412231445],[66.1535949707031,54.3805465698242],[66.2194366455078,54.2805480957031],[66.1180419921875,54.2374954223633],[66.2061004638672,54.1833267211914],[66.2785949707031,54.1902694702148],[66.35693359375,54.0844345092773],[66.2144317626953,54.0769424438477],[66.0013885498047,53.9947128295898],[66.0361022949219,53.9180526733398],[66.0758209228516,53.9152679443359],[66.0658111572266,53.7927703857422],[66.1649932861328,53.7811050415039],[66.1830444335938,53.6824951171875],[66.1177520751953,53.6308212280273],[66.1116485595703,53.4927673339844],[66.2552642822266,53.4855499267578],[66.2688751220703,53.2827682495117],[66.2663879394531,53.1938781738281],[66.4144287109375,53.1686019897461],[66.4052581787109,53.0997161865234],[66.2035980224609,53.1044387817383],[66.0819396972656,53.0627670288086],[66.0777740478516,52.9630508422852],[66.4127655029297,52.9522171020508],[66.4088745117188,52.9033203125],[66.1436004638672,52.8861083984375],[66.1344299316406,52.8199920654297],[66.0524749755859,52.818603515625],[66.0319014630981,52.5],[52.5,52.5],[52.5,54.3222587134538],[52.5116653442383,54.3219375610352],[52.5374450683594,54.3770751953125],[52.6219329833984,54.3411026000977],[52.6877670288086,54.3611068725586],[52.9230499267578,54.3138809204102],[52.9324951171875,54.2880477905273],[52.8816604614258,54.2777709960938],[52.9291610717773,54.2680511474609],[53.0136108398438,54.2680511474609],[53.0294342041016,54.289436340332],[53.0013885498047,54.3124923706055],[53.047492980957,54.3416595458984],[53.1158294677734,54.2494354248047],[52.9369354248047,54.2136077880859],[53.0336074829102,54.1274871826172],[53.0913772583008,54.1205444335938],[53.060546875,54.0699920654297],[53.1944351196289,54.0983276367188],[53.272216796875,54.0699920654297],[53.2849960327148,54.0274887084961],[53.3719329833984,53.9674911499023],[53.4108200073242,54.0269393920898],[53.4701995849609,54.0451965332031],[53.4130477905273,54.2222137451172],[53.4344329833984,54.269157409668],[53.3613815307617,54.3288803100586],[53.3444366455078,54.3869400024414],[53.4219360351562,54.4866561889648],[53.4105453491211,54.5574951171875],[53.6086044311523,54.7113800048828],[53.5788803100586,54.7488784790039],[53.6077728271484,54.8124923706055],[53.5769424438477,54.8149948120117],[53.6424942016602,54.9013824462891],[53.5141220092773,54.8812026977539],[53.406379699707,54.9972152709961],[53.2669372558594,55.0102767944336],[53.2683334350586,55.0533218383789],[53.1413803100586,55.093879699707],[53.1388854980469,55.1438827514648],[53.3344345092773,55.1624908447266],[53.3380432128906,55.1949920654297],[53.3994369506836,55.2210998535156],[53.5861053466797,55.2077713012695],[53.5999984741211,55.2602767944336],[53.7091598510742,55.3336029052734],[53.8983306884766,55.3816604614258],[53.9333267211914,55.4586029052734],[53.996940612793,55.5002746582031],[53.9963836669922,55.5497207641602],[54.1783294677734,55.6227645874023],[54.2419357299805,55.6913757324219],[54.0952758789062,55.7759246826172],[54.0261001586914,55.7566604614258],[54.0382080078125,55.8009567260742],[53.9702682495117,55.7824935913086],[53.9972152709961,55.850830078125],[53.6384201049805,55.9155197143555],[53.6719360351562,55.9599914550781],[53.7847213745117,55.9691543579102],[53.8379440307617,56.0437698364258],[54.0244369506836,56.0294342041016],[54.1072158813477,56.1474914550781],[54.35888671875,56.2622146606445],[54.3752670288086,56.3049926757812],[54.3152694702148,56.3413772583008],[54.352409362793,56.3585662841797],[54.3247146606445,56.4624938964844],[54.2361068725586,56.4358215332031],[54.1847152709961,56.5372161865234],[54.1219329833984,56.5336074829102],[54.0908279418945,56.5824966430664],[54.0266571044922,56.5841598510742],[54.100830078125,56.6627655029297],[54.0286026000977,56.6927642822266],[53.9638824462891,56.631103515625],[53.869987487793,56.6074981689453],[53.8355484008789,56.6355514526367],[53.8808212280273,56.6722183227539],[53.8063812255859,56.773323059082],[53.8283309936523,56.8119354248047],[53.8894348144531,56.8044357299805],[53.8899917602539,56.7644424438477],[54.0105514526367,56.7491607666016],[54.0917739868164,56.7917327880859],[54.0980453491211,56.9624938964844],[54.4026794433594,57.0365600585938],[54.3744354248047,57.0738830566406],[54.2755508422852,57.100830078125],[54.334716796875,57.1555480957031],[54.3199920654297,57.2866592407227],[54.1163864135742,57.3102722167969],[54.1444396972656,57.3869400024414],[54.2716598510742,57.4222183227539],[54.2647171020508,57.4644393920898],[54.1786041259766,57.4649963378906],[54.1658248901367,57.5122146606445],[54.2036056518555,57.5308227539062],[54.1699905395508,57.5597152709961],[54.1188812255859,57.5594329833984],[54.1013870239258,57.5180511474609],[53.9874954223633,57.5711059570312],[54.1211013793945,57.6119384765625],[54.0691604614258,57.6666641235352],[54.1566543579102,57.7024917602539],[54.1363830566406,57.8322143554688],[54.0874938964844,57.9133224487305],[54.1072158813477,57.9727630615234],[53.9427642822266,58.0952682495117],[53.894157409668,58.1880416870117],[53.8097152709961,58.228874206543],[53.88916015625,58.3222198486328],[53.7902755737305,58.3924942016602],[53.7846298217773,58.4399642944336],[53.6960983276367,58.6033248901367],[53.7572174072266,58.6524887084961],[53.7402725219727,58.6797180175781],[53.7705459594727,58.7163848876953],[53.9283294677734,58.7816619873047],[53.8072128295898,58.8277740478516],[53.7191543579102,58.9374923706055],[53.7649993896484,59.0227661132812],[53.8447113037109,59.0305480957031],[53.8349914550781,59.0583267211914],[53.884162902832,59.0905456542969],[53.7541656494141,59.1411056518555],[53.6891555786133,59.1233215332031],[53.7236022949219,59.0919342041016],[53.3855514526367,59.1555480957031],[53.2441558837891,59.2758255004883],[53.2047119140625,59.3494338989258],[53.3661041259766,59.5183258056641],[53.4205474853516,59.6897125244141],[53.6027755737305,59.7005462646484],[53.7119369506836,60.0033264160156],[53.598876953125,60.1566543579102],[53.411376953125,60.2244338989258],[53.3861083984375,60.1655426025391],[53.0108261108398,60.1591567993164],[52.5,60.1975747693231],[52.5,60.9742026367824],[52.7949905395508,60.9443283081055],[52.8766555786133,61.093879699707],[53.3849945068359,61.0338821411133],[53.3394317626953,60.8938827514648],[53.5738830566406,60.8649978637695],[53.8091583251953,60.847770690918],[53.8655471801758,60.9874954223633],[54.9797134399414,60.863883972168],[55.0610656738281,61.019401550293],[55.1974716186523,61.0041046142578],[55.2792129516602,61.1295928955078],[55.7232284545898,61.0814590454102],[55.8285751342773,61.2505722045898],[56.2902755737305,61.2030487060547],[56.3480453491211,61.2938842773438],[56.3163833618164,61.3252716064453],[56.3886032104492,61.4394302368164],[56.5452728271484,61.4288787841797],[56.600830078125,61.5024948120117],[56.6755523681641,61.5277709960938],[57.0966567993164,61.4852676391602],[57.1799926757812,61.5119400024414],[58.8097152709961,61.5055541992188],[58.940544128418,61.5597152709961],[59.0108261108398,61.5447158813477],[59.1433258056641,61.6330490112305],[59.348876953125,61.6822128295898],[59.3969421386719,61.7611083984375],[59.3391571044922,61.8022155761719],[59.3413772583008,61.8569412231445],[59.4855499267578,61.9880447387695],[59.4044342041016,62.142219543457],[59.5152740478516,62.3172149658203],[59.6002731323242,62.3669357299805],[59.584716796875,62.4149932861328],[59.60888671875,62.4533233642578],[59.6505432128906,62.5172119140625],[59.5097198486328,62.5472183227539],[59.3913803100586,62.7297134399414],[59.460823059082,62.7791595458984],[59.4872131347656,62.8977737426758],[59.4247131347656,62.9441528320312],[59.2766571044922,62.9666595458984],[59.2222137451172,63.0738830566406],[59.3027725219727,63.1263809204102],[59.2588882446289,63.2011032104492],[59.3386001586914,63.2899932861328],[59.2824935913086,63.3327713012695],[59.3522186279297,63.3630523681641],[59.3172149658203,63.3988800048828],[59.4777679443359,63.5680541992188],[59.5138854980469,63.7799911499023],[59.5724945068359,63.8366546630859],[59.5658264160156,63.9191589355469],[59.7705459594727,63.9994354248047],[59.8597183227539,64.1374969482422],[59.7338790893555,64.1533203125],[59.5880432128906,64.2324829101562],[59.5794372558594,64.2794342041016],[59.6361083984375,64.3374938964844],[59.6047134399414,64.4602661132812],[59.4797134399414,64.48193359375],[59.6136093139648,64.6227569580078],[59.7024917602539,64.6516571044922],[59.6380462646484,64.723876953125],[59.6541595458984,64.7833251953125],[60.1580429077148,65.0672149658203],[60.427490234375,65.0519256591797],[60.4297180175781,65.0008239746094],[60.5963821411133,64.9419250488281],[60.6313781738281,64.8836059570312],[60.8119354248047,65.0485992431641],[60.9627685546875,65.0416564941406],[61.1116638183594,65.1722106933594],[61.2394332885742,65.1855316162109],[61.3336029052734,65.2888793945312],[61.2491607666016,65.3188781738281],[61.4155426025391,65.3963775634766],[61.5822143554688,65.5516510009766],[61.6869354248047,65.5738830566406],[61.8702697753906,65.7022094726562],[62.1130523681641,65.7208251953125],[62.6819381713867,65.863037109375],[62.6938781738281,65.8633117675781],[62.73193359375,65.8577575683594],[62.8611068725586,65.8780364990234],[62.7977752685547,65.9310913085938],[62.8883285522461,65.97998046875],[62.817497253418,66.0119323730469],[62.8616638183594,66.0772094726562],[62.9591598510742,66.1097106933594],[63.0469436645508,66.2247009277344],[63.1538772583008,66.2674865722656],[63.2905502319336,66.2327575683594],[63.3041610717773,66.2747039794922],[63.2233200073242,66.3263854980469],[63.4085998535156,66.4527740478516],[63.4091567993164,66.4810943603516],[63.5372161865234,66.4602661132812],[63.6588821411133,66.5258178710938],[63.815544128418,66.5472106933594],[63.9827651977539,66.6535949707031],[64.3124847412109,66.6644287109375],[64.4127655029297,66.723876953125],[64.5399780273438,66.7272033691406],[64.5760955810547,66.7991485595703],[65.1013793945312,66.8905487060547],[65.1055450439453,67.0080413818359],[65.0705413818359,67.0394287109375],[65.2213745117188,67.0769348144531],[65.1824798583984,67.1508178710938],[65.6588745117188,67.3060913085938],[65.7188720703125,67.3405456542969],[65.6724853515625,67.3660888671875],[65.6905364990234,67.3866577148438],[65.9613800048828,67.395263671875],[66.1066436767578,67.4785919189453],[66.0920715663487,67.5],[67.5,67.5],[67.5,60.8533248901367],[67.5,59.4197158813477],],
			},
		},
		# Grid 4:5 ; 2 records
		"5" => {
			"333" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,1",
				"p" => [[54.2419357299805,67.5],[52.5,67.5],[52.5,82.5],[67.5,82.5],[67.5,71.4012342149176],[67.0858154296875,71.3038635253906],[66.9155426025391,71.2927551269531],[66.8366546630859,71.209716796875],[66.7838745117188,71.1422119140625],[66.6215438842773,71.0488510131836],[66.5422821044922,70.9287948608398],[66.6127624511719,70.8677291870117],[66.6888732910156,70.7605438232422],[67.1072082519531,70.8352661132812],[67.2288665771484,70.8255462646484],[67.3324890136719,70.7688751220703],[67.3397064208984,70.7249908447266],[67.2088775634766,70.5266571044922],[67.2922058105469,70.4699859619141],[67.2519378662109,70.4483184814453],[67.2666625976562,70.4111022949219],[67.19970703125,70.3902740478516],[67.0886154174805,70.2162399291992],[67.0793991088867,70.127326965332],[66.9938659667969,70.0488739013672],[66.8733062744141,70.0010986328125],[66.7672119140625,69.7572174072266],[66.7919311523438,69.5802764892578],[66.9380111694336,69.5222625732422],[66.9540710449219,69.4052810668945],[67.1615447998047,69.3593521118164],[67.2549514770508,69.4029846191406],[67.3705520629883,69.5216522216797],[67.3852844238281,69.6185913085938],[67.5,69.6050261878686],[67.5,68.6239179150499],[67.3233795166016,68.6927947998047],[67.2781982421875,68.7496795654297],[67.3815155029297,68.7663955688477],[67.3906326293945,68.8043746948242],[67.1200485229492,68.8411407470703],[66.5562744140625,68.9116744995117],[66.5233612060547,68.9670867919922],[66.2572021484375,69.0725402832031],[65.7958221435547,69.1369705200195],[65.3819274902344,69.1847076416016],[65.0483245849609,69.2733154296875],[64.9149932861328,69.2547149658203],[64.9427490234375,69.2047119140625],[64.8325653076172,69.1521301269531],[64.5199890136719,69.0177612304688],[64.5174865722656,68.9824829101562],[64.5838775634766,68.9608154296875],[64.5213775634766,68.9077606201172],[64.5499877929688,68.8705291748047],[64.7458190917969,68.8552551269531],[64.7549896240234,68.8852691650391],[64.8041534423828,68.8919372558594],[65.0805511474609,68.8088684082031],[65.2022094726562,68.8233184814453],[65.3486022949219,68.7919311523438],[65.3263854980469,68.7249908447266],[65.4049835205078,68.7327575683594],[65.4294281005859,68.6999969482422],[65.3783111572266,68.6805419921875],[65.5236053466797,68.5841522216797],[65.6616516113281,68.5469360351562],[65.6144256591797,68.5255432128906],[65.6060943603516,68.4849853515625],[65.4805450439453,68.4305419921875],[65.2677612304688,68.2199859619141],[65.3333282470703,68.0863800048828],[65.2849884033203,68.0119323730469],[65.4347076416016,67.9180450439453],[65.7805480957031,67.9233093261719],[65.9108123779297,67.9633178710938],[66.0861053466797,67.9344177246094],[66.0924835205078,67.8902740478516],[66.0544281005859,67.8808135986328],[66.0180511474609,67.7930450439453],[66.1838684082031,67.7483215332031],[66.2105407714844,67.6960906982422],[66.1052551269531,67.6455383300781],[65.9927520751953,67.6791534423828],[65.8405456542969,67.6519317626953],[65.8180541992188,67.6260833740234],[65.8683166503906,67.6066436767578],[65.7916564941406,67.5697174072266],[66.0397033691406,67.5769348144531],[66.0920715663487,67.5],[52.5583267211914,67.5],[54.2419357299805,67.5],],
			},
			"574" => {
				"z" => "Etc/GMT+5",
				"c" => "ESRI",
				"s" => "37,2",
				"p" => [[67.5,69.3460998535156],[67.5,67.5],[66.0920715663487,67.5],[66.0397033691406,67.5769348144531],[65.7916564941406,67.5697174072266],[65.8683166503906,67.6066436767578],[65.8180541992188,67.6260833740234],[65.8405456542969,67.6519317626953],[65.9927520751953,67.6791534423828],[66.1052551269531,67.6455383300781],[66.2105407714844,67.6960906982422],[66.1838684082031,67.7483215332031],[66.0180511474609,67.7930450439453],[66.0544281005859,67.8808135986328],[66.0924835205078,67.8902740478516],[66.0861053466797,67.9344177246094],[65.9108123779297,67.9633178710938],[65.7805480957031,67.9233093261719],[65.4347076416016,67.9180450439453],[65.2849884033203,68.0119323730469],[65.3333282470703,68.0863800048828],[65.2677612304688,68.2199859619141],[65.4805450439453,68.4305419921875],[65.6060943603516,68.4849853515625],[65.6144256591797,68.5255432128906],[65.6616516113281,68.5469360351562],[65.5236053466797,68.5841522216797],[65.3783111572266,68.6805419921875],[65.4294281005859,68.6999969482422],[65.4049835205078,68.7327575683594],[65.3263854980469,68.7249908447266],[65.3486022949219,68.7919311523438],[65.2022094726562,68.8233184814453],[65.0805511474609,68.8088684082031],[64.8041534423828,68.8919372558594],[64.7549896240234,68.8852691650391],[64.7458190917969,68.8552551269531],[64.5499877929688,68.8705291748047],[64.5213775634766,68.9077606201172],[64.5838775634766,68.9608154296875],[64.5174865722656,68.9824829101562],[64.5199890136719,69.0177612304688],[64.8325653076172,69.1521301269531],[64.9427490234375,69.2047119140625],[64.9149932861328,69.2547149658203],[65.0483245849609,69.2733154296875],[65.3819274902344,69.1847076416016],[65.7958221435547,69.1369705200195],[66.2572021484375,69.0725402832031],[66.5233612060547,68.9670867919922],[66.5562744140625,68.9116744995117],[67.1200485229492,68.8411407470703],[67.3906326293945,68.8043746948242],[67.3815155029297,68.7663955688477],[67.2781982421875,68.7496795654297],[67.3233795166016,68.6927947998047],[67.5,68.6239179150499],[67.5,69.6050261878686],[67.3852844238281,69.6185913085938],[67.3705520629883,69.5216522216797],[67.2549514770508,69.4029846191406],[67.1615447998047,69.3593521118164],[66.9540710449219,69.4052810668945],[66.9380111694336,69.5222625732422],[66.7919311523438,69.5802764892578],[66.7672119140625,69.7572174072266],[66.8733062744141,70.0010986328125],[66.9938659667969,70.0488739013672],[67.0793991088867,70.127326965332],[67.0886154174805,70.2162399291992],[67.19970703125,70.3902740478516],[67.2666625976562,70.4111022949219],[67.2519378662109,70.4483184814453],[67.2922058105469,70.4699859619141],[67.2088775634766,70.5266571044922],[67.3397064208984,70.7249908447266],[67.3324890136719,70.7688751220703],[67.2288665771484,70.8255462646484],[67.1072082519531,70.8352661132812],[66.6888732910156,70.7605438232422],[66.6127624511719,70.8677291870117],[66.5422821044922,70.9287948608398],[66.6215438842773,71.0488510131836],[66.7838745117188,71.1422119140625],[66.8366546630859,71.209716796875],[66.9155426025391,71.2927551269531],[67.0858154296875,71.3038635253906],[67.5,71.4012342149176],[67.5,69.8816528320312],[67.5,69.3460998535156],],
			},
		},
		# Grid 4:6 ; 1 records
		"6" => {
			"334" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,1",
				"p" => [[54.2419357299805,82.5],[52.5,82.5],[52.5,82.8151035677391],[67.5,82.8900979370742],[67.5,82.5],[52.5583267211914,82.5],[54.2419357299805,82.5],],
			},
		},
	},
};

# Used by Class::Singleton
sub _new_instance
{
	return shift->_init( @_, data => $data );
}

1;
