package Google::Ads::AdWords::v201306::LanguageSearchParameter;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/o/v201306' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201306::SearchParameter);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %SearchParameter__Type_of :ATTR(:get<SearchParameter__Type>);
my %languages_of :ATTR(:get<languages>);

__PACKAGE__->_factory(
    [ qw(        SearchParameter__Type
        languages

    ) ],
    {
        'SearchParameter__Type' => \%SearchParameter__Type_of,
        'languages' => \%languages_of,
    },
    {
        'SearchParameter__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'languages' => 'Google::Ads::AdWords::v201306::Language',
    },
    {

        'SearchParameter__Type' => 'SearchParameter.Type',
        'languages' => 'languages',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201306::LanguageSearchParameter

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
LanguageSearchParameter from the namespace https://adwords.google.com/api/adwords/o/v201306.

A {@link SearchParameter} for both {@code PLACEMENT} and {@code KEYWORD} {@link IdeaType}s used to indicate multiple language being targeted. This can be used, for example, to search for {@code KEYWORD} {@link IdeaType}s that are best for Japanese language. <p>The service allows at most one language to be targeted for KEYWORD requests and 10 languages for PLACEMENT requests. <p>This search parameter can be used in bulk keyword requests through the {@link com.google.ads.api.services.targetingideas.TargetingIdeaService#getBulkKeywordIdeas(TargetingIdeaSelector)} method. It must be single-valued when used in a call to that method. <p>This element is supported by following {@link IdeaType}s: KEYWORD, PLACEMENT. <p>This element is supported by following {@link RequestType}s: IDEAS, STATS. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * languages




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

