#!/usr/bin/perl

package eBay::API::XML::Call::GetUserDisputes::GetUserDisputesResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetUserDisputesResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetUserDisputes::GetUserDisputesResponseType

=head1 DESCRIPTION

Returns a list of disputes that involve the calling user
as buyer or seller, in response to a GetUserDisputesRequest.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetUserDisputes::GetUserDisputesResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::DisputeArrayType;
use eBay::API::XML::DataType::DisputeFilterCountType;
use eBay::API::XML::DataType::DisputeIDType;
use eBay::API::XML::DataType::PaginationResultType;


my @gaProperties = ( [ 'DisputeArray', 'ns:DisputeArrayType', ''
	     ,'eBay::API::XML::DataType::DisputeArrayType', '1' ]
	, [ 'DisputeFilterCount', 'ns:DisputeFilterCountType', '1'
	     ,'eBay::API::XML::DataType::DisputeFilterCountType', '1' ]
	, [ 'EndingDisputeID', 'ns:DisputeIDType', ''
	     ,'eBay::API::XML::DataType::DisputeIDType', '1' ]
	, [ 'ItemsPerPage', 'xs:int', '', '', '' ]
	, [ 'PageNumber', 'xs:int', '', '', '' ]
	, [ 'PaginationResult', 'ns:PaginationResultType', ''
	     ,'eBay::API::XML::DataType::PaginationResultType', '1' ]
	, [ 'StartingDisputeID', 'ns:DisputeIDType', ''
	     ,'eBay::API::XML::DataType::DisputeIDType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDisputeArray()

The array of disputes returned.

#    Argument: 'ns:DisputeArrayType'

=cut

sub setDisputeArray {
  my $self = shift;
  $self->{'DisputeArray'} = shift
}

=head2 getDisputeArray()

  Returned: Always
  Details: DetailLevel: ReturnSummary, ReturnAll, none
#    Returns: 'ns:DisputeArrayType'

=cut

sub getDisputeArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'DisputeArray'
		,'eBay::API::XML::DataType::DisputeArrayType');
}


=head2 setDisputeFilterCount()

The number of disputes that involve the requester as
buyer or seller and match a given filter type.

#    Argument: reference to an array  
                      of 'ns:DisputeFilterCountType'

=cut

sub setDisputeFilterCount {
  my $self = shift;
  $self->{'DisputeFilterCount'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getDisputeFilterCount()

  Returned: Always
  Details: DetailLevel: ReturnSummary, ReturnAll, none
#    Returns: reference to an array  
                      of 'ns:DisputeFilterCountType'

=cut

sub getDisputeFilterCount {
  my $self = shift;
  return $self->_getDataTypeArray('DisputeFilterCount');
}


=head2 setEndingDisputeID()

The index of the last dispute in the current result set, relative
to the total number of disputes available.
Primarily useful for interpreting paginated results.
For example, if 228 disputes are available and
200 results are returned per page: The first page returns
an EndingDisputeID value of 200 and the second page returns an
EndingDisputeID value of 228.

#    Argument: 'ns:DisputeIDType'

=cut

sub setEndingDisputeID {
  my $self = shift;
  $self->{'EndingDisputeID'} = shift
}

=head2 getEndingDisputeID()

  Returned: Always
  Details: DetailLevel: ReturnSummary, ReturnAll, none
#    Returns: 'ns:DisputeIDType'

=cut

sub getEndingDisputeID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'EndingDisputeID'
		,'eBay::API::XML::DataType::DisputeIDType');
}


=head2 setItemsPerPage()

The number of disputes on each virtual page in the result set.
The virtual page returned is determined by PageNumber.
Default is 200.

#    Argument: 'xs:int'

=cut

sub setItemsPerPage {
  my $self = shift;
  $self->{'ItemsPerPage'} = shift
}

=head2 getItemsPerPage()

  Returned: Always
  Details: DetailLevel: ReturnSummary, ReturnAll, none
#    Returns: 'xs:int'

=cut

sub getItemsPerPage {
  my $self = shift;
  return $self->{'ItemsPerPage'};
}


=head2 setPageNumber()

The page of the total result set returned in the call. The entire result set
is virtual and the call returns only one page of it.

#    Argument: 'xs:int'

=cut

sub setPageNumber {
  my $self = shift;
  $self->{'PageNumber'} = shift
}

=head2 getPageNumber()

  Returned: Always
  Details: DetailLevel: ReturnSummary, ReturnAll, none
#    Returns: 'xs:int'

=cut

sub getPageNumber {
  my $self = shift;
  return $self->{'PageNumber'};
}


=head2 setPaginationResult()

The result of the pagination, including the total number
of virtual pages in the result set and the total number of
disputes returned.

#    Argument: 'ns:PaginationResultType'

=cut

sub setPaginationResult {
  my $self = shift;
  $self->{'PaginationResult'} = shift
}

=head2 getPaginationResult()

  Returned: Always
  Details: DetailLevel: ReturnSummary, ReturnAll, none
#    Returns: 'ns:PaginationResultType'

=cut

sub getPaginationResult {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PaginationResult'
		,'eBay::API::XML::DataType::PaginationResultType');
}


=head2 setStartingDisputeID()

The index of the first dispute in the current result set, relative
to the total number of disputes available.
Primarily useful for interpreting paginated results.
For example, if 228 disputes are available and
200 results are returned per page: The first page returns
a StartingDisputeID value of 1 and the second page returns a
StartingDisputeID value of 201.

#    Argument: 'ns:DisputeIDType'

=cut

sub setStartingDisputeID {
  my $self = shift;
  $self->{'StartingDisputeID'} = shift
}

=head2 getStartingDisputeID()

  Returned: Always
  Details: DetailLevel: ReturnSummary, ReturnAll, none
#    Returns: 'ns:DisputeIDType'

=cut

sub getStartingDisputeID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'StartingDisputeID'
		,'eBay::API::XML::DataType::DisputeIDType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
