#!/usr/bin/perl

package eBay::API::XML::Call::GetVeROReasonCodeDetails;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetVeROReasonCodeDetails.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetVeROReasonCodeDetails

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetVeROReasonCodeDetails inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetVeROReasonCodeDetails::GetVeROReasonCodeDetailsRequestType;
use eBay::API::XML::Call::GetVeROReasonCodeDetails::GetVeROReasonCodeDetailsResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetVeROReasonCodeDetails';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetVeROReasonCodeDetails::GetVeROReasonCodeDetailsRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetVeROReasonCodeDetails::GetVeROReasonCodeDetailsResponseType';
}

#
# input properties
#

=head2 setReasonCodeID()

Unique identifier for a reason code. If this ReasonCodeID is passed then 
only details of this ReasonCodeID will be returned. If no reason code is 
specified, all reason codes are returned.

Max: Default: Min: 
  RequiredInput: Conditionally
#    Argument: 'xs:long'

=cut
       
sub setReasonCodeID {
   my $self   = shift;
   my $sReasonCodeID = shift;
   $self->getRequestDataType()->setReasonCodeID($sReasonCodeID);
}

=head2 setReturnAllSites()

Set to true to retrieve reason codes for all sites. If not specified, 
reason codes are returned for the site specified in the request header 
only. 
If ReasonCodeID is specified, this parameter is ignored.

Default: false

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setReturnAllSites {
   my $self   = shift;
   my $sReturnAllSites = shift;
   $self->getRequestDataType()->setReturnAllSites($sReturnAllSites);
}



#
# output properties
#

=head2 getVeROReasonCodeDetails()

Contains the list of the status codes for a site.

  Returned: Always
#    Returns: 'ns:VeROReasonCodeDetailsType'

=cut
       
sub getVeROReasonCodeDetails {
   my $self = shift;
   return $self->getResponseDataType()->getVeROReasonCodeDetails();
}





1;   
