#!/usr/bin/perl

package eBay::API::XML::DataType::NotificationDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. NotificationDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::NotificationDetailsType

=head1 DESCRIPTION

Information about a single notification. Notification information includes
the reference ID, notification type, current status, time delivered, error code,
and error message for the notification. If notification details are included in
the response, all of the detail fields are returned.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::NotificationDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::NotificationEventStateCodeType;
use eBay::API::XML::DataType::Enum::NotificationEventTypeCodeType;


my @gaProperties = ( [ 'DeliveryStatus', 'ns:NotificationEventStateCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::NotificationEventStateCodeType', '' ]
	, [ 'DeliveryTime', 'xs:dateTime', '', '', '' ]
	, [ 'DeliveryURL', 'xs:anyURI', '', '', '' ]
	, [ 'DeliveryURLName', 'xs:string', '', '', '' ]
	, [ 'ErrorMessage', 'xs:string', '', '', '' ]
	, [ 'ExpirationTime', 'xs:dateTime', '', '', '' ]
	, [ 'NextRetryTime', 'xs:dateTime', '', '', '' ]
	, [ 'ReferenceID', 'xs:string', '', '', '' ]
	, [ 'Retries', 'xs:int', '', '', '' ]
	, [ 'Type', 'ns:NotificationEventTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::NotificationEventTypeCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDeliveryStatus()

Returns the notification status. Possible values include Delivered,
Failed, Rejected, and MarkedDown.

#    Argument: 'ns:NotificationEventStateCodeType'

=cut

sub setDeliveryStatus {
  my $self = shift;
  $self->{'DeliveryStatus'} = shift
}

=head2 getDeliveryStatus()

  Calls: GetNotificationsUsage
  Returned: Conditionally

#    Returns: 'ns:NotificationEventStateCodeType'

=cut

sub getDeliveryStatus {
  my $self = shift;
  return $self->{'DeliveryStatus'};
}


=head2 setDeliveryTime()

Returns the time when the notification was delivered.

#    Argument: 'xs:dateTime'

=cut

sub setDeliveryTime {
  my $self = shift;
  $self->{'DeliveryTime'} = shift
}

=head2 getDeliveryTime()

  Calls: GetNotificationsUsage
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getDeliveryTime {
  my $self = shift;
  return $self->{'DeliveryTime'};
}


=head2 setDeliveryURL()

Returns the destination address for the notification. This is the value set
using SetNotificationPreferences.

#    Argument: 'xs:anyURI'

=cut

sub setDeliveryURL {
  my $self = shift;
  $self->{'DeliveryURL'} = shift
}

=head2 getDeliveryURL()

  Calls: GetNotificationsUsage
  Returned: Conditionally

#    Returns: 'xs:anyURI'

=cut

sub getDeliveryURL {
  my $self = shift;
  return $self->{'DeliveryURL'};
}


=head2 setDeliveryURLName()

Returns the delivery URL name for the notification. This is the value set
using SetNotificationPreferences.

#    Argument: 'xs:string'

=cut

sub setDeliveryURLName {
  my $self = shift;
  $self->{'DeliveryURLName'} = shift
}

=head2 getDeliveryURLName()

  Calls: GetNotificationsUsage
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getDeliveryURLName {
  my $self = shift;
  return $self->{'DeliveryURLName'};
}


=head2 setErrorMessage()

Returns the error message.

#    Argument: 'xs:string'

=cut

sub setErrorMessage {
  my $self = shift;
  $self->{'ErrorMessage'} = shift
}

=head2 getErrorMessage()

  Calls: GetNotificationsUsage
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getErrorMessage {
  my $self = shift;
  return $self->{'ErrorMessage'};
}


=head2 setExpirationTime()

Date and time when this notification will be removed from the
eBay system.

#    Argument: 'xs:dateTime'

=cut

sub setExpirationTime {
  my $self = shift;
  $self->{'ExpirationTime'} = shift
}

=head2 getExpirationTime()

  Calls: GetNotificationsUsage
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getExpirationTime {
  my $self = shift;
  return $self->{'ExpirationTime'};
}


=head2 setNextRetryTime()

Returns the time when the notification is scheduled for retry.
This won't be included if the DeliveryStatus is Delivered.

#    Argument: 'xs:dateTime'

=cut

sub setNextRetryTime {
  my $self = shift;
  $self->{'NextRetryTime'} = shift
}

=head2 getNextRetryTime()

  Calls: GetNotificationsUsage
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getNextRetryTime {
  my $self = shift;
  return $self->{'NextRetryTime'};
}


=head2 setReferenceID()

Reference identifier for the notification.

#    Argument: 'xs:string'

=cut

sub setReferenceID {
  my $self = shift;
  $self->{'ReferenceID'} = shift
}

=head2 getReferenceID()

#    Returns: 'xs:string'

=cut

sub getReferenceID {
  my $self = shift;
  return $self->{'ReferenceID'};
}


=head2 setRetries()

Returns the total number of retries for the given notification.

#    Argument: 'xs:int'

=cut

sub setRetries {
  my $self = shift;
  $self->{'Retries'} = shift
}

=head2 getRetries()

  Calls: GetNotificationsUsage
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getRetries {
  my $self = shift;
  return $self->{'Retries'};
}


=head2 setType()

Returns the notification type. Possible values include: AskSellerQuestion,
AuctionCheckoutComplete, BestOffer, CheckoutBuyerRequestTotal, EndOfAuction,
Feedback, FixedPriceEndOfTransaction, FixedPriceTransaction, ItemNotReceived,
MyMessages, OutBid, SecondChanceOffer, UPIBuyerResponseDispute, UPISellerClosedDispute,
UPISellerOpenedDispute, and UPISellerRespondedToDispute.

#    Argument: 'ns:NotificationEventTypeCodeType'

=cut

sub setType {
  my $self = shift;
  $self->{'Type'} = shift
}

=head2 getType()

  Calls: GetNotificationsUsage
  Returned: Conditionally

#    Returns: 'ns:NotificationEventTypeCodeType'

=cut

sub getType {
  my $self = shift;
  return $self->{'Type'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
