#!/usr/bin/perl

package eBay::API::XML::Call::CompleteSale::CompleteSaleRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CompleteSaleRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::CompleteSale::CompleteSaleRequestType

=head1 DESCRIPTION

Enables a seller to do various tasks after an item transaction or
multiple-item order has been created.
A seller can leave feedback for the buyer, change the paid status,
or set shipment tracking information (or any combination of these).
Only the seller who listed the item or order can perform these tasks.
<br><br>
Applies to Half.com, except when using OrderID.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::CompleteSale::CompleteSaleRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::FeedbackInfoType;
use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::ShipmentType;
use eBay::API::XML::DataType::Enum::ListingTypeCodeType;


my @gaProperties = ( [ 'FeedbackInfo', 'ns:FeedbackInfoType', ''
	     ,'eBay::API::XML::DataType::FeedbackInfoType', '1' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'ListingType', 'ns:ListingTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ListingTypeCodeType', '' ]
	, [ 'OrderID', 'xs:string', '', '', '' ]
	, [ 'Paid', 'xs:boolean', '', '', '' ]
	, [ 'Shipment', 'ns:ShipmentType', ''
	     ,'eBay::API::XML::DataType::ShipmentType', '1' ]
	, [ 'Shipped', 'xs:boolean', '', '', '' ]
	, [ 'TransactionID', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setFeedbackInfo()

Specifies feedback the seller is leaving for the buyer.
For a given transaction, the seller can leave feedback once,
and no further modifications can be made to that feedback entry.
If feedback has already been left, FeedbackInfo is not allowed.
Call GetFeedback to determine whether feedback has already been left.

  RequiredInput: No
#    Argument: 'ns:FeedbackInfoType'

=cut

sub setFeedbackInfo {
  my $self = shift;
  $self->{'FeedbackInfo'} = shift
}

=head2 getFeedbackInfo()

#    Returns: 'ns:FeedbackInfoType'

=cut

sub getFeedbackInfo {
  my $self = shift;
  return $self->_getDataTypeInstance( 'FeedbackInfo'
		,'eBay::API::XML::DataType::FeedbackInfoType');
}


=head2 setItemID()

ID of the listing associated with the transaction that the
seller is completing.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setListingType()

If included in the request, and with a value of
ListingType = Half, indicates that the given ItemID and
TransactionID values are for Half.com. ListingType is
required input for Half.com items.

  RequiredInput: Conditionally
  OnlyTheseValues: Half
#    Argument: 'ns:ListingTypeCodeType'

=cut

sub setListingType {
  my $self = shift;
  $self->{'ListingType'} = shift
}

=head2 getListingType()

#    Returns: 'ns:ListingTypeCodeType'

=cut

sub getListingType {
  my $self = shift;
  return $self->{'ListingType'};
}


=head2 setOrderID()

Unique ID for a multi-item order. ItemID and TransactionID are
ignored if a call includes OrderID. CompleteSale applies to the
specified order as a whole (and thus the child transactions
associated with the order).
<br>
This tag does not apply to half.com items.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setOrderID {
  my $self = shift;
  $self->{'OrderID'} = shift
}

=head2 getOrderID()

#    Returns: 'xs:string'

=cut

sub getOrderID {
  my $self = shift;
  return $self->{'OrderID'};
}


=head2 setPaid()

If true, the transaction is marked as paid in My eBay.
If false, the transaction is marked as not paid in My eBay.
If not specified, the paid status in My eBay is not modified.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setPaid {
  my $self = shift;
  $self->{'Paid'} = shift
}

=head2 isPaid()

#    Returns: 'xs:boolean'

=cut

sub isPaid {
  my $self = shift;
  return $self->{'Paid'};
}


=head2 setShipment()

Details about the shipment. Setting the tracking number and carrier
automatically marks the item as shipped (sets Shipped to true).

  RequiredInput: No
#    Argument: 'ns:ShipmentType'

=cut

sub setShipment {
  my $self = shift;
  $self->{'Shipment'} = shift
}

=head2 getShipment()

#    Returns: 'ns:ShipmentType'

=cut

sub getShipment {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Shipment'
		,'eBay::API::XML::DataType::ShipmentType');
}


=head2 setShipped()

If true, the transaction is marked as shipped in My eBay
(applicable for Selling Manager Pro users).
If false, the transaction is marked as not shipped in My eBay.
If not specified, the shipped status in My eBay is not modified.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setShipped {
  my $self = shift;
  $self->{'Shipped'} = shift
}

=head2 isShipped()

#    Returns: 'xs:boolean'

=cut

sub isShipped {
  my $self = shift;
  return $self->{'Shipped'};
}


=head2 setTransactionID()

Unique identifier for a transaction from the listing indicated by ItemID.
Call GetItemTransactions or GetSellerTransactions to determine
the appropriate transaction ID.
Required for all listing types (pass 0 for Chinese auctions).

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

  RequiredInput: Yes
#    Argument: 'xs:string'

=cut

sub setTransactionID {
  my $self = shift;
  $self->{'TransactionID'} = shift
}

=head2 getTransactionID()

#    Returns: 'xs:string'

=cut

sub getTransactionID {
  my $self = shift;
  return $self->{'TransactionID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
